/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.AbstractBalmConfig;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.entity.BalmEntity;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.proxy.SidedProxy;
import net.blay09.mods.balm.config.ExampleConfig;
import net.blay09.mods.balm.fabric.FabricBalmHooks;
import net.blay09.mods.balm.fabric.FabricBalmProxy;
import net.blay09.mods.balm.fabric.fluid.BalmFluidStorage;
import net.blay09.mods.balm.fabric.provider.FabricBalmProviders;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1263;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class FabricBalm
implements ModInitializer {
    private static final SidedProxy<FabricBalmProxy> proxy = Balm.sidedProxy("net.blay09.mods.balm.fabric.FabricBalmProxy", "net.blay09.mods.balm.fabric.client.FabricBalmClientProxy");

    public void onInitialize() {
        ((FabricBalmHooks)Balm.getHooks()).initialize();
        ((AbstractBalmConfig)Balm.getConfig()).initialize();
        ExampleConfig.initialize();
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            class_2487 data = ((BalmEntity)oldPlayer).getFabricBalmData();
            ((BalmEntity)newPlayer).setFabricBalmData(data);
        });
        FabricBalmProviders providers = (FabricBalmProviders)Balm.getProviders();
        providers.registerProvider(class_2960.method_60655((String)"balm", (String)"container"), class_1263.class);
        providers.registerProvider(class_2960.method_60655((String)"balm", (String)"fluid_tank"), FluidTank.class);
        providers.registerProvider(class_2960.method_60655((String)"balm", (String)"energy_storage"), EnergyStorage.class);
        ItemStorage.SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            BalmContainerProvider containerProvider;
            class_1263 container;
            if (blockEntity instanceof BalmContainerProvider && (container = (containerProvider = (BalmContainerProvider)blockEntity).getContainer((class_2350)direction)) != null) {
                return InventoryStorage.of((class_1263)container, (class_2350)direction);
            }
            return null;
        });
        FluidStorage.SIDED.registerFallback((world, pos, state, blockEntity, direction) -> {
            BalmFluidTankProvider fluidTankProvider;
            FluidTank fluidTank;
            if (blockEntity instanceof BalmFluidTankProvider && (fluidTank = (fluidTankProvider = (BalmFluidTankProvider)blockEntity).getFluidTank((class_2350)direction)) != null) {
                return new BalmFluidStorage(fluidTank);
            }
            return null;
        });
        Balm.initializeIfLoaded("team_reborn_energy", "net.blay09.mods.balm.fabric.compat.energy.RebornEnergy");
    }

    public static FabricBalmProxy getProxy() {
        return proxy.get();
    }
}

